var Iroom;
(function (Iroom) {
    var Components = (function () {
        function Components() {
            this.body = document.body;
            this.alerts = document.querySelectorAll(".alert.dismissable");
            this.links = document.querySelectorAll(".disabled, [readonly]");
            this.asideLinks = document.querySelectorAll(".aside-nav a");
            this.inputContainers = document.querySelectorAll(".input-group:not(.input-password), .input-group-left:not(.input-password), .input-group-double:not(.input-password)");
            this.inputPasswordContainers = document.querySelectorAll(".input-password");
            this.filters = document.querySelectorAll(".filters .filter-button");
            this.dropdowns = document.querySelectorAll(".dropdown");
            this.mobileMenu = document.querySelectorAll("div.mobile-menu");
            this.init();
        }
        Components.prototype.init = function () {
            this.disabledEvent();
            this.asideNavEvent();
            this.closeEvent();
            this.inputsEvent();
            this.passwordInputEvent();
            this.filtersEvent();
            this.dropdownEvent();
            this.menuEvent();
        };
        Components.prototype.asideNavEvent = function () {
            var _this = this;
            window.addEventListener('scroll', function (e) {
                _this.resetActiveClass(_this.asideLinks);
                for (var i in _this.asideLinks) {
                    if (_this.asideLinks[i]) {
                        var link = _this.asideLinks[i];
                        if (_this.getAttr(link, "href")) {
                            var anchor = link.getAttribute("href").substr(1);
                            var item = document.getElementById(anchor);
                            if (item != null) {
                                var scrollTop = document.documentElement.scrollTop || document.body.scrollTop;
                                if (scrollTop >= item.offsetTop) {
                                    _this.resetActiveClass(_this.asideLinks);
                                    link.classList.add("active");
                                }
                            }
                        }
                    }
                }
            });
        };
        Components.prototype.resetActiveClass = function (links) {
            for (var i in links) {
                if (links[i]) {
                    var link = links[i];
                    if (typeof link == "object" && link.classList) {
                        link.classList.remove("active");
                    }
                }
            }
        };
        Components.prototype.disabledEvent = function () {
            for (var i in this.links) {
                if (this.links[i]) {
                    var link = this.links[i];
                    if (typeof link == "object") {
                        link.addEventListener('click', function (e) {
                            e.preventDefault();
                        });
                    }
                }
            }
        };
        Components.prototype.closeEvent = function () {
            var _loop_1 = function () {
                if (this_1.alerts[i]) {
                    var alert_1 = this_1.alerts[i];
                    if (typeof alert_1 == "object") {
                        alert_1.addEventListener('click', function (e) {
                            e.preventDefault();
                            if (alert_1.classList) {
                                alert_1.classList.add("closed");
                            }
                        });
                    }
                }
            };
            var this_1 = this;
            for (var i in this.alerts) {
                _loop_1();
            }
        };
        Components.prototype.inputsEvent = function () {
            var _loop_2 = function () {
                if (this_2.inputContainers[i]) {
                    var container_1 = this_2.inputContainers[i];
                    if (typeof container_1 == "object") {
                        container_1.addEventListener("click", function () {
                            var input = container_1.querySelectorAll("input, select, textarea")[0];
                            if (typeof input == "object") {
                                input.focus();
                            }
                        });
                    }
                }
            };
            var this_2 = this;
            for (var i in this.inputContainers) {
                _loop_2();
            }
        };
        Components.prototype.passwordInputEvent = function () {
            var _this = this;
            var _loop_3 = function () {
                if (this_3.inputPasswordContainers[i]) {
                    var container = this_3.inputPasswordContainers[i];
                    if (typeof container == "object") {
                        var spans = container.querySelectorAll("span");
                        var input_1 = container.querySelectorAll("input, select, textarea")[0];
                        var _loop_4 = function () {
                            if (spans[ii]) {
                                var span_1 = spans[ii];
                                if (typeof span_1 == "object" && typeof input_1 == "object") {
                                    span_1.addEventListener("click", function () {
                                        if (_this.getAttr(input_1, "type")) {
                                            if (_this.getAttr(input_1, "type") == "password") {
                                                input_1.setAttribute("type", "text");
                                                span_1.innerHTML = '<i class="fa fa-eye-slash"></i>';
                                            }
                                            else {
                                                input_1.setAttribute("type", "password");
                                                span_1.innerHTML = '<i class="fa fa-eye"></i>';
                                            }
                                        }
                                        input_1.focus();
                                    });
                                }
                            }
                        };
                        for (var ii in spans) {
                            _loop_4();
                        }
                    }
                }
            };
            var this_3 = this;
            for (var i in this.inputPasswordContainers) {
                _loop_3();
            }
        };
        Components.prototype.filtersEvent = function () {
            var _this = this;
            var _loop_5 = function () {
                if (this_4.filters[i]) {
                    var button_1 = this_4.filters[i];
                    if (typeof button_1 == "object") {
                        button_1.addEventListener("click", function (e) {
                            e.preventDefault();
                            button_1.classList.add("active");
                            var targets = document.querySelectorAll('.filters .filter-display.filter-disabled');
                            for (var ii in targets) {
                                if (targets[ii]) {
                                    var target = targets[ii];
                                    if (typeof target == "object") {
                                        target.classList.remove("filter-disabled");
                                    }
                                }
                            }
                            var value = _this.getAttr(button_1, "data-filter");
                            if (value !== "all") {
                                var targetsFiltered = document.querySelectorAll('.filters .filter-display:not([data-filter="' + value + '"])');
                                for (var iii in targetsFiltered) {
                                    if (targetsFiltered[iii]) {
                                        var targetFiltered = targetsFiltered[iii];
                                        if (typeof targetFiltered == "object") {
                                            targetFiltered.classList.add("filter-disabled");
                                        }
                                    }
                                }
                            }
                        });
                    }
                }
            };
            var this_4 = this;
            for (var i in this.filters) {
                _loop_5();
            }
        };
        Components.prototype.dropdownEvent = function () {
            var _this = this;
            var _loop_6 = function () {
                if (this_5.dropdowns[i]) {
                    var dropdown_1 = this_5.dropdowns[i];
                    if (typeof dropdown_1 == "object") {
                        var target = dropdown_1.querySelector("[data-expanded]");
                        if (target) {
                            target.addEventListener("click", function () {
                                _this.resetDropdown(dropdown_1);
                                _this.classToggle(dropdown_1, "open");
                            });
                        }
                    }
                }
            };
            var this_5 = this;
            for (var i in this.dropdowns) {
                _loop_6();
            }
        };
        Components.prototype.resetDropdown = function (active) {
            for (var ii in this.dropdowns) {
                if (this.dropdowns[ii]) {
                    var elem = this.dropdowns[ii];
                    if (typeof elem == "object") {
                        if (elem !== active) {
                            elem.classList.remove("open");
                        }
                    }
                }
            }
        };
        Components.prototype.menuEvent = function () {
            var _this = this;
            var _loop_7 = function () {
                if (this_6.mobileMenu[i]) {
                    var hamburger_1 = this_6.mobileMenu[i];
                    if (typeof hamburger_1 == "object") {
                        hamburger_1.addEventListener("click", function () {
                            var targetSelector = _this.getAttr(hamburger_1, "data-menu");
                            if (targetSelector) {
                                var target = document.querySelector('#' + targetSelector);
                                if (target) {
                                    _this.classToggle(hamburger_1, "open");
                                    _this.classToggle(_this.body, "mobile-menu-enabled");
                                    _this.classToggle(target, "mobile-menu-enabled");
                                }
                            }
                        });
                    }
                }
            };
            var this_6 = this;
            for (var i in this.mobileMenu) {
                _loop_7();
            }
        };
        Components.prototype.getAttr = function (ele, attr) {
            var result = (ele.getAttribute && ele.getAttribute(attr)) || null;
            if (!result) {
                var attrs = ele.attributes;
                if (attrs != null) {
                    var length = attrs.length;
                    for (var i = 0; i < length; i++) {
                        if (attrs[i].nodeName === attr) {
                            result = attrs[i].nodeValue;
                        }
                    }
                }
            }
            return result;
        };
        Components.prototype.classToggle = function (ele, string) {
            if (ele.classList.contains(string)) {
                ele.classList.remove(string);
            }
            else {
                ele.classList.add(string);
            }
        };
        return Components;
    }());
    Iroom.Components = Components;
})(Iroom || (Iroom = {}));
new Iroom.Components();
var Iroom;
(function (Iroom) {
    var Lightbox = (function () {
        function Lightbox(options) {
            if (options === void 0) { options = null; }
            this.options = options;
            this.html = document.getElementsByTagName("html")[0];
            this.body = document.body;
            this.createLightBox();
            this.init();
        }
        Lightbox.prototype.createLightBox = function () {
            var lightboxBackground = document.createElement('div');
            lightboxBackground.className = 'lightboxBackground';
            lightboxBackground.classList.add('top');
            this.showcase = document.createElement('img');
            this.showcase.classList.add("showcase");
            this.next = document.createElement('button');
            this.next.className = 'next';
            this.next.innerHTML = '<i class="fa fa-chevron-right"></i>';
            this.prev = document.createElement('button');
            this.prev.className = 'prev';
            this.prev.innerHTML = '<i class="fa fa-chevron-left"></i>';
            this.close = document.createElement('button');
            this.close.innerHTML = '<i class="fa fa-close"></i>';
            this.close.className = 'close';
            this.count = document.createElement('p');
            this.count.innerHTML = '';
            this.count.className = 'count';
            lightboxBackground.appendChild(this.showcase);
            lightboxBackground.appendChild(this.close);
            lightboxBackground.appendChild(this.prev);
            lightboxBackground.appendChild(this.next);
            lightboxBackground.appendChild(this.count);
            this.lightboxBackground = lightboxBackground;
            this.body.appendChild(lightboxBackground);
            this.lightbox = document.querySelectorAll('.lightbox');
        };
        Lightbox.prototype.init = function () {
            this.lightBoxEvent();
            this.prevEvent();
            this.nextEvent();
            this.closeEvent();
        };
        Lightbox.prototype.lightBoxEvent = function () {
            var _this = this;
            this.index = null;
            var _loop_8 = function (i) {
                if (this_7.lightbox[i]) {
                    var parent_1 = this_7.lightbox[i];
                    var arr = Array.prototype.slice.call(this_7.lightbox);
                    var index_1 = arr.indexOf(parent_1);
                    parent_1.addEventListener('click', function (e) {
                        _this.gallery = [];
                        _this.count.innerHTML = '';
                        if (parent_1 != null) {
                            var element = parent_1.querySelectorAll('img')[0];
                            element.setAttribute('index', String(index_1));
                            if (element != null) {
                                _this.showcase.src = element.src;
                                _this.showcase.setAttribute('index', String(index_1));
                                if (typeof _this.gallery === 'undefined' || !_this.gallery.length) {
                                    _this.gallery = document.querySelectorAll(".lightbox[data-gallery=\"" + parent_1.getAttribute("data-gallery") + "\"] img");
                                }
                                if (typeof _this.index === 'undefined' || _this.index === null) {
                                    for (var i in _this.gallery) {
                                        if (_this.gallery[i]) {
                                            var image = _this.gallery[i];
                                            if (_this.getAttr(image, "index") &&
                                                _this.getAttr(_this.showcase, "index") &&
                                                _this.getAttr(image, "index") ==
                                                    _this.getAttr(_this.showcase, "index")) {
                                                _this.index = parseInt(i);
                                            }
                                        }
                                    }
                                }
                                _this.lightboxBackground.classList.add('active');
                                _this.html.classList.add('showcase');
                                _this.body.classList.add('showcase');
                                _this.showcase.classList.add('active');
                                _this.checkCommand(_this.index);
                                _this.enableArrowNavigation();
                            }
                        }
                    });
                }
            };
            var this_7 = this;
            for (var i = 0; i < this.lightbox.length; i++) {
                _loop_8(i);
            }
        };
        Lightbox.prototype.prevEvent = function () {
            var _this = this;
            this.prev.addEventListener('click', function (e) {
                var img = _this.gallery[--_this.index];
                _this.showcase.src = img.src;
                _this.checkCommand(_this.index);
            });
        };
        Lightbox.prototype.nextEvent = function () {
            var _this = this;
            this.next.addEventListener('click', function (e) {
                var img = _this.gallery[++_this.index];
                _this.showcase.src = img.src;
                _this.checkCommand(_this.index);
            });
        };
        Lightbox.prototype.closeEvent = function () {
            var _this = this;
            this.close.addEventListener('click', function (e) {
                e.preventDefault();
                _this.index = null;
                _this.showcase.classList.remove('active');
                _this.showcase.removeAttribute('index');
                _this.lightboxBackground.classList.remove('active');
                _this.html.classList.remove('showcase');
                _this.body.classList.remove('showcase');
            });
        };
        Lightbox.prototype.checkCommand = function (index) {
            if (index === void 0) { index = null; }
            if (index > 0 && this.gallery.length > 1) {
                this.prev.classList.add('active');
            }
            else {
                this.prev.classList.remove('active');
            }
            if (index < this.gallery.length - 1) {
                this.next.classList.add('active');
            }
            else {
                this.next.classList.remove('active');
            }
            if (index >= 0 && this.gallery.length >= 1) {
                this.count.innerHTML = '<i class="fa fa-camera"></i> ' + (this.index + 1) + ' of ' + this.gallery.length;
            }
        };
        Lightbox.prototype.enableArrowNavigation = function () {
            var _this = this;
            document.onkeydown = function (e) {
                switch (e.keyCode) {
                    case 37:
                        e.preventDefault();
                        if (_this.prev.classList.contains('active')) {
                            _this.prev.click();
                        }
                        break;
                    case 39:
                        e.preventDefault();
                        if (_this.next.classList.contains('active')) {
                            _this.next.click();
                        }
                        break;
                    case 27:
                        e.preventDefault();
                        _this.close.click();
                        break;
                }
            };
        };
        Lightbox.prototype.getAttr = function (ele, attr) {
            var result = (ele.getAttribute && ele.getAttribute(attr)) || null;
            if (!result) {
                var attrs = ele.attributes;
                if (attrs != null) {
                    var length = attrs.length;
                    for (var i = 0; i < length; i++) {
                        if (attrs[i].nodeName === attr) {
                            result = attrs[i].nodeValue;
                        }
                    }
                }
            }
            return result;
        };
        return Lightbox;
    }());
    Iroom.Lightbox = Lightbox;
})(Iroom || (Iroom = {}));
var Iroom;
(function (Iroom) {
    var Loader = (function () {
        function Loader(options) {
            if (options === void 0) { options = null; }
            this.body = document.body;
            this.loader = document.getElementById("loader");
            this.options = options;
            this.links = document.querySelectorAll("body.animated a");
            this.init();
        }
        Loader.prototype.init = function () {
            this.setDelay();
            this.pageInEvent(this.body);
            this.pageOutEvent(this.body);
        };
        Loader.prototype.pageInEvent = function (body) {
            setTimeout(function () {
                body.classList.remove("animated");
            }, this.delay);
        };
        Loader.prototype.pageOutEvent = function (body) {
            var _this = this;
            var _loop_9 = function () {
                if (this_8.links[i]) {
                    var link_1 = this_8.links[i];
                    if (!link_1.classList || !link_1.classList.contains("close,next,prev")) {
                        if (this_8.getAttr(link_1, "href") && this_8.getAttr(link_1, "href")[0] !== "#" && this_8.getAttr(link_1, "href") !== "" && this_8.getAttr(link_1, "target") != "_blank") {
                            link_1.addEventListener('click', function (e) {
                                e.preventDefault();
                                _this.body.classList.add("animated");
                                var url = _this.getAttr(link_1, "href");
                                setTimeout(function () {
                                    location.href = url;
                                }, _this.delay);
                                setTimeout(function () {
                                    _this.body.classList.remove("animated");
                                }, _this.delay * 1.5);
                            });
                        }
                    }
                }
            };
            var this_8 = this;
            for (var i in this.links) {
                _loop_9();
            }
        };
        Loader.prototype.setDelay = function () {
            this.delay = 1000;
            if (this.options != null && this.options.duration > 0) {
                this.delay = this.options.duration;
            }
            if (this.loader != null && parseInt(this.loader.getAttribute("data-duration")) > 0) {
                this.delay = parseInt(this.loader.getAttribute("data-duration"));
            }
        };
        Loader.prototype.getAttr = function (ele, attr) {
            var result = (ele.getAttribute && ele.getAttribute(attr)) || null;
            if (!result) {
                var attrs = ele.attributes;
                if (attrs != null) {
                    var length = attrs.length;
                    for (var i = 0; i < length; i++) {
                        if (attrs[i].nodeName === attr) {
                            result = attrs[i].nodeValue;
                        }
                    }
                }
            }
            return result;
        };
        return Loader;
    }());
    Iroom.Loader = Loader;
})(Iroom || (Iroom = {}));
var Iroom;
(function (Iroom) {
    var ScrollToTop = (function () {
        function ScrollToTop(options) {
            if (options === void 0) { options = null; }
            this.link = null;
            this.options = options;
            this.link = document.getElementById("scrollToTop");
            this.init();
        }
        ScrollToTop.prototype.init = function () {
            this.scrollEvent();
        };
        ScrollToTop.prototype.scrollEvent = function () {
            var _this = this;
            window.addEventListener('scroll', function (e) {
                var scrollTop = window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0;
                if (scrollTop > 500) {
                    _this.link.classList.remove("hidden");
                }
                else {
                    _this.link.classList.add("hidden");
                }
            });
            this.link.addEventListener('click', function (e) {
                e.preventDefault();
                _this.setDelay(_this.link);
                _this.scrollTo(0, _this.delay);
            });
        };
        ScrollToTop.prototype.setDelay = function (link) {
            this.delay = 1000;
            if (this.options !== null && this.options.duration > 0) {
                this.delay = this.options.duration;
            }
            if (link !== null && parseInt(this.getAttr(link, "data-duration")) > 0) {
                this.delay = parseInt(this.getAttr(link, "data-duration"));
            }
        };
        ScrollToTop.prototype.scrollTo = function (to, duration) {
            var start = window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0, change = to - start, increment = 20;
            var animateScroll = function (elapsedTime) {
                elapsedTime += increment;
                var position = easeInOut(elapsedTime, start, change, duration);
                document.documentElement.scrollTop = position;
                document.body.scrollTop = position;
                if (elapsedTime < duration) {
                    setTimeout(function () {
                        animateScroll(elapsedTime);
                    }, increment);
                }
            };
            var easeInOut = function (currentTime, start, change, duration) {
                currentTime /= duration / 2;
                if (currentTime < 1) {
                    return change / 2 * currentTime * currentTime + start;
                }
                currentTime -= 1;
                return -change / 2 * (currentTime * (currentTime - 2) - 1) + start;
            };
            animateScroll(0);
        };
        ScrollToTop.prototype.getAttr = function (ele, attr) {
            var result = (ele.getAttribute && ele.getAttribute(attr)) || null;
            if (!result) {
                var attrs = ele.attributes;
                if (attrs != null) {
                    var length = attrs.length;
                    for (var i = 0; i < length; i++) {
                        if (attrs[i].nodeName === attr) {
                            result = attrs[i].nodeValue;
                        }
                    }
                }
            }
            return result;
        };
        return ScrollToTop;
    }());
    Iroom.ScrollToTop = ScrollToTop;
})(Iroom || (Iroom = {}));
var Iroom;
(function (Iroom) {
    var Smooth = (function () {
        function Smooth(options) {
            if (options === void 0) { options = null; }
            this.options = options;
            this.links = document.querySelectorAll("a");
            this.init();
        }
        Smooth.prototype.init = function () {
            this.scrollEvent();
        };
        Smooth.prototype.scrollEvent = function () {
            var _this = this;
            var _loop_10 = function () {
                if (this_9.links[i]) {
                    var link_2 = this_9.links[i];
                    if (!link_2.classList || !link_2.classList.contains("close,next,prev")) {
                        if (this_9.getAttr(link_2, "href") && this_9.getAttr(link_2, "href")[0] === "#" && this_9.getAttr(link_2, "href")[1] !== "!" && this_9.getAttr(link_2, "href")[1] !== "0" && this_9.getAttr(link_2, "href")[1] !== null) {
                            link_2.addEventListener('click', function (e) {
                                e.preventDefault();
                                _this.setDelay(link_2);
                                var url = _this.getAttr(link_2, "href").substr(1);
                                var element = document.getElementById(url);
                                if (element !== null) {
                                    _this.scrollTo(element.offsetTop, _this.delay);
                                }
                            });
                        }
                    }
                }
            };
            var this_9 = this;
            for (var i in this.links) {
                _loop_10();
            }
        };
        Smooth.prototype.setDelay = function (link) {
            this.delay = 1000;
            if (this.options != null && this.options.duration > 0) {
                this.delay = this.options.duration;
            }
            if (link != null && parseInt(link.getAttribute("data-duration")) > 0) {
                this.delay = parseInt(link.getAttribute("data-duration"));
            }
        };
        Smooth.prototype.scrollTo = function (to, duration) {
            var start = window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0, change = to - start, increment = 20;
            var animateScroll = function (elapsedTime) {
                elapsedTime += increment;
                var position = easeInOut(elapsedTime, start, change, duration);
                document.documentElement.scrollTop = position;
                document.body.scrollTop = position;
                if (elapsedTime < duration) {
                    setTimeout(function () {
                        animateScroll(elapsedTime);
                    }, increment);
                }
            };
            var easeInOut = function (currentTime, start, change, duration) {
                currentTime /= duration / 2;
                if (currentTime < 1) {
                    return change / 2 * currentTime * currentTime + start;
                }
                currentTime -= 1;
                return -change / 2 * (currentTime * (currentTime - 2) - 1) + start;
            };
            animateScroll(0);
        };
        Smooth.prototype.getAttr = function (ele, attr) {
            var result = (ele.getAttribute && ele.getAttribute(attr)) || null;
            if (!result) {
                var attrs = ele.attributes;
                if (attrs != null) {
                    var length = attrs.length;
                    for (var i = 0; i < length; i++) {
                        if (attrs[i].nodeName === attr) {
                            result = attrs[i].nodeValue;
                        }
                    }
                }
            }
            return result;
        };
        return Smooth;
    }());
    Iroom.Smooth = Smooth;
})(Iroom || (Iroom = {}));
